/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org2.eclipse.dltk.ast.references.TypeReference;
import org2.eclipse.dltk.ast.references.VariableReference;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.compiler.ast.nodes.VarComment;

public class ASTUtils {
    private static final Pattern VAR_COMMENT_PATTERN = Pattern.compile("(.*)(\\$[\\S]+)(\\s+)([\\S]+).*");

    public static VarComment parseVarComment(AST ast, String content, int start, int end) {
        Matcher m = VAR_COMMENT_PATTERN.matcher(content);
        if (m.matches()) {
            int typeEnd;
            String typeName;
            int varStart = start + m.group(1).length();
            String varName = m.group(2);
            int varEnd = varStart + varName.length();
            ArrayList<TypeReference> typeReferences = new ArrayList<TypeReference>();
            int typeStart = varEnd + m.group(3).length();
            String types = m.group(4);
            int pipeIdx = types.indexOf(124);
            while (pipeIdx >= 0) {
                typeName = types.substring(0, pipeIdx);
                typeEnd = typeStart + typeName.length();
                if (typeName.length() > 0) {
                    typeReferences.add(new TypeReference(typeStart, typeEnd, typeName));
                }
                types = types.substring(pipeIdx + 1);
                typeStart += pipeIdx + 1;
                pipeIdx = types.indexOf(124);
            }
            typeName = types;
            typeEnd = typeStart + typeName.length();
            if (typeName.length() > 0) {
                typeReferences.add(new TypeReference(typeStart, typeEnd, typeName));
            }
            VariableReference varReference = new VariableReference(varStart, varEnd, varName);
            VarComment varComment = new VarComment(start, end, ast, varReference, typeReferences.toArray(new TypeReference[typeReferences.size()]));
            return varComment;
        }
        return null;
    }
}

